# -*- coding:cp1251 -*-

#hahmoille luokka missä luodaan kaikki objectit ja niiden toiminnot määritellään

import pygame
from fysiikat import Fysiikka as F
import tyokalut #Oma functio luokka missä apufunckareita

TYOKALU = tyokalut.Functiot()

class Ukko:
	def __init__(self):
		#statsit
		self.happi = 20.0 # 1 = 1s.
		self.maxHappi = 120.0
		self.elama = 20
		self.maxElama = 20
		self.ammukset = 5
		self.maxAmmukset = 20
		self.armor = 0 #arvo joka miinustetaan vihun lämästä
		self.koko = [16,24] #ukon hit box
		self.nimi = "ukko"

		#liikkuminen
		self.koords = [50,0]
		self.nopeus_x = 0.0
		self.nopeus_y = 0.0
		self.maxNopeus_x = 3
		self.maxNopeus_y = 8
		self.kiihtyvyys_x = 0.6 #Nopeus yksikköä framessa, juostessa
		self.kiihtyvyys_y = 0 #ukon kiihtyvyys ylöspäin (hypyn alussa saa arvon ja alkaa vähenemään hypyn aikana)
		self.haluttuSuunta = [0,0] #mihinkä suuntaan ollaan liikuttamassa ukkoa näppäimistöllä (x-akseli, y-akseli) on vain suunta arvo ei nopeus

		self.osuukoLattiaan = 0 #arvot joista nähdään kävelyn liikuttaessa osuuko pelajaa seinään --> ei liikuteta sinne päin enään
		self.osuukoSeinaan_V = 0
		self.osuukoSeinaan_O = 0
		self.osuukoKattoon = 0
		self.kameraTriggerointi_x = 150 #Kuinka monta pikseliä saadaan kävellä näytön reunaan ennenkuin kamera alkaa seuraamaan
		self.kameraTriggerointi_y = 100
		self.putoamisKiihtyvyys = 1
		self.oltiinMenossa = 0 #kertoo mihinkä suuntaan oltiin menossa ennen pysahtymista (-1 vas 1 oik)

		self.hypataan = 0 #Haluaako pelaaja hypätä (onko hyppynappi pohjassa)
		self.ylosPohjas = 0
		self.alasPohjas = 0 #Onko nappi pohjas

		#Kartasta tarvittavat tiedot (esim. katran koordinaatit ja tileset koko)
		self.KARTTA = None

		#animointi
		kuva = pygame.image.load("media/spritet/pelihahmo.png")
		self.kaikkiSpritet = TYOKALU.LataaSpritet(kuva, self.koko) #kaikki ukon mahdolliset animaatio kuvat
		#self.LataaSpritet()
		self.animoitavat = [0, 1, 2] #spritet joita animoidaan tässä järjestyksessä vuoronperään
		self.animMenossa = 0

	def KirjaaPohjassa(self, nappi):
		if nappi[0] == "y":
			self.ylosPohjas = int(nappi[1])
		if nappi[0] == "a":
			self.alasPohjas = int(nappi[1])

	def LaskeObjecti(self, UKKO, KARTTA):
		#maailman objectien laskennan function rajapinta
		if self.elama < 1:
			print "GAME OVER"
			time.spleep(2)
		self.happi -= 0.1
		if self.happi <= 0:
			self.elama -= 1
			self.happi = 20.0
		#print "Happi: " + str(self.happi) + " Elama: " + str(self.elama)
	
	def Liiku(self):
		# --- X nopeuden laskeminen ---
		if self.haluttuSuunta[0] < 0: #Eli negatiivista
				self.nopeus_x += self.haluttuSuunta[0]
				if self.nopeus_x < -1 * self.maxNopeus_x:
					self.nopeus_x = -self.maxNopeus_x
					#print "Nopeus nyt: " + str(self.nopeus_x)

		if self.haluttuSuunta[0] > 0: #Eli positiivista
				self.nopeus_x += self.haluttuSuunta[0]
				if self.nopeus_x > self.maxNopeus_x:
					#print "Oli lian kovaa eli sun nopeus: " + str(self.nopeus_x) + "ja max: " + str(self.maxNopeus_x)
					self.nopeus_x = self.maxNopeus_x
					#print "nopeus nyt: " + str(self.nopeus_x)
		#Ukon hidastuminen jos ei haluta liikkua mihinkään
		if self.haluttuSuunta[0] == 0:
			if self.nopeus_x > 0:
				self.nopeus_x -= 1
			if self.nopeus_x < 0:
				self.nopeus_x += 1
		#Tarkistetaan törmätäänkö seinään
		if self.nopeus_x > 0:
			if self.osuukoSeinaan_O == 1:
				self.nopeus_x = 0 #Eli törmäsit seinään
				#alla tarkistus paljonko ollaan seinan sisalla
				#mun_x = self.koords[0] + self.KARTTA.koords[0]
				#erotus = (mun_x + self.koko[0]) % self.KARTTA.tile_koko #korjaus koska ukko ei ole 2 x tilekoko
				#self.koords[0] -= erotus
			else:
				if self.osuukoLattiaan == 1: #Jos liikkuu sivulle ja on maassa
					self.animoitavat = [0,1,2]
				else:
					self.animoitavat = [1,1,1]
			self.oltiinMenossa = 1
					
				
		if self.nopeus_x < 0:
			if self.osuukoSeinaan_V == 1:
				self.nopeus_x = 0 #Eli törmäsit seinään
			else:
				if self.osuukoLattiaan == 1:
					self.animoitavat = [3,4,5]
				else:
					self.animoitavat = [4,4,4]
			self.oltiinMenossa = -1 #kertoo vanhan suunnan paikallaan olo animaatiolle ( ja tippumiselle)

		if self.nopeus_x == 0:
			if self.oltiinMenossa < 0:
				self.animoitavat = [9,9,9]
				if self.osuukoSeinaan_V == 1:
					#alla tarkistus paljonko ollaan seinan sisalla
					mun_x = self.koords[0] + self.KARTTA.koords[0]
					erotus = self.KARTTA.tile_koko - (mun_x % self.KARTTA.tile_koko) #korjaus koska ukko ei ole 2 x tilekoko HOXHOX lasketaan törmäys tilen vas sein.
					self.koords[0] += (erotus -1) #-1 korjaa jakolaskun pyöristys virheet pois
			else:
				self.animoitavat = [6,6,6]
				if self.osuukoSeinaan_O == 1:
					#alla tarkistus paljonko ollaan seinan sisalla
					mun_x = self.koords[0] + self.KARTTA.koords[0]
					erotus = (mun_x + self.koko[0]) % self.KARTTA.tile_koko #korjaus koska ukko ei ole 2 x tilekoko
					self.koords[0] -= erotus
				

		self.koords[0] += int(self.nopeus_x) #Lopulta kun on tehty kaikki nopeus_x laskennat... Liikuta ukkoa nopeuden mukaan

		#--- Y nopeuden laskeminen ---
		if self.osuukoLattiaan == 0:
			self.nopeus_y += self.putoamisKiihtyvyys #Painovoima päällä jos ei osuta lattiaan HOX HOX tänne voi ohjelmoida seinähyppy ominaisuuden
		else:

			self.nopeus_y = 0
			#alla tarkistus paljonko ollaan lattian sisalla
			mun_y = self.koords[1] + self.KARTTA.koords[1]
			erotus = mun_y % self.KARTTA.tile_koko -8 #korjaus koska ukko ei ole 2 x tilekoko
			self.koords[1] -= erotus
		if self.osuukoKattoon == 1:
			if self.nopeus_y < 0: #jos ollaan menossa ylöspäin
				self.nopeus_y = 0
		if self.hypataan == 1: #Halutaan hypätä tai hyppynappi pohjassa
			#print "Hyppynappi pohjas"
			if self.osuukoLattiaan == 1: #Jos ollaan yhä lattiassa (eli aloitetaan hyppäämään)
				#print "olet lattiassa"
				self.nopeus_y = -6
			elif self.nopeus_y < 0:
				self.nopeus_y -= 0.8	
				#print "et ollut lattiassa"
		if self.nopeus_y > self.maxNopeus_y: self.nopeus_y = self.maxNopeus_y #rajoitin nopeuteen
		if self.nopeus_y < -self.maxNopeus_y: self.nopeus_y = -self.maxNopeus_y #rajoitim mopeuteen ylöspäin
		self.koords[1] += int(self.nopeus_y)
		self.TormaysKarttaan()

	def Menossa(self, akseli, paljonko):
		#Tallennetaan ukon propertyyn mihinkä suuntaan halutaan näppäimistösyötteen mukaan mennä jotta se voidaan laskea myöhemmin
		self.haluttuSuunta[akseli] = paljonko
	def LopetaMenossa(self, suunta):
		if suunta > 0:
			if self.haluttuSuunta[0] > 0:
				self.haluttuSuunta[0] = 0
		if suunta < 0:
			if self.haluttuSuunta[0] < 0:
				self.haluttuSuunta[0] = 0

	def Hypataan(self, tosi):
		self.hypataan = 1

	def VaihdaAnimoitava(self):
		self.animMenossa = TYOKALU.VaihdaAnimoitava(self.animoitavat, self.animMenossa)

	def Teleporttaa(self, koords):
		self.KARTTA.koords[0] = -100
		self.KARTTA.koords[1] = -100
		self.koords = koords
		print "Kartta: (%s , %s ) Hahmo: ( %s , %s )" % (self.KARTTA.koords[0], self.KARTTA.koords[1], self.koords[0], self.koords[1])
	
	def TeleporttaaSuhteellisesti(self, koords):
		self.koords[0] += koords[0]
		self.koords[1] += koords[1]

	def TormaysKarttaan(self):
		#Täällä lasketaan törmätäänkö karttaan (jos törmätäään osuuko = TRUE)
		self.osuukoSeinaan_V = 0
		self.osuukoSeinaan_O = 0
		self.osuukoKattoon = 0
		self.OsuukoLattiaan = 0

		#lasketaan ukolle 6 pistettä ympärille (ylä, ala, ala_oikea, ala_vsen, yla_oikea. yla_vasen) ja jokainen niistä saa merkata trörmäys flagin
		x=self.KARTTA.koords[0] + self.koords[0] + self.koko[0] / 2
		y=self.KARTTA.koords[1] + self.koords[1]
		yla = [x,y]

		x=self.KARTTA.koords[0] + self.koords[0] + self.koko[0] / 2
		y=self.KARTTA.koords[1] + self.koords[1] + self.koko[1]
		ala = [x,y]

		x=self.KARTTA.koords[0] + self.koords[0] + 16
		y=self.KARTTA.koords[1] + self.koords[1]+12
		ala_o = [x,y]

		x=self.KARTTA.koords[0] + self.koords[0]
		y=self.KARTTA.koords[1] + self.koords[1] + 12
		ala_v = [x,y]

		x=self.KARTTA.koords[0] + self.koords[0] + self.koko[0]
		y=self.KARTTA.koords[1] + self.koords[1] + 3
		yla_o = [x,y]

		x=self.KARTTA.koords[0] + self.koords[0]
		y=self.KARTTA.koords[1] + self.koords[1] + 3
		yla_v = [x,y]

		self.osuukoKattoon = self.AnnaTormaysFlagi(yla)
		self.osuukoLattiaan = self.AnnaTormaysFlagi(ala)
		if self.AnnaTormaysFlagi(yla_o) == 1 or self.AnnaTormaysFlagi(ala_o) == 1: self.osuukoSeinaan_O = 1
		if self.AnnaTormaysFlagi(yla_v) == 1 or self.AnnaTormaysFlagi(ala_v) == 1: self.osuukoSeinaan_V = 1
		
		#print "kaikki hitbox pisteet: yla(%s,%s) yla_o(%s,%s) ala_o(%s,%s) ala(%s,%s) ala_v(%s,%s) yla_v(%s,%s)" % (yla[0], yla[1], yla_o[0], yla_o[1], ala_o[0], ala_o[1], ala[0], ala[1], ala_v[0], ala_v[1], yla_v[0], yla_v[1])

		''' #Vanha ei täysin toimiva törmäys laskenta (koska yhdelle pisteelle vain)
		print "olet tilen sisalla: " + str(tilenSisal_x) + "," + str(tilenSisal_y) + "tilenro: " + str(tilenro)
		if tilenro != 0:
			#Eli ollaan päällekkäin kartta tilen kanssa --> lasketaan lyhin reitti ulos tilestä (eli suunta mistä tultiin sisälle)
			tilenSeina_V = self.KARTTA.tile_koko * tilenSisal_x #lasketaan tilen vasemman seinän koordinaatit
			tilenKatto = self.KARTTA.tile_koko * tilenSisal_y #Lasketaan tilen ylä seinän koordinaatit
			
			etaisyysVas =(self.KARTTA.koords[0] + self.koords[0]) - tilenSeina_V		#Lasketaan pelaajan etäisyys tilen sisällä olevaan vasempaan seinään
			etaisyysOik = (tilenSeina_V + self.KARTTA.tile_koko) - (self.KARTTA.koords[0] + self.koords[0]) 	#Lasketaan pelaajan etäisyys oikeaan seinään
			etaisyysYla =(self.KARTTA.koords[1] + self.koords[1]) - tilenKatto	 #Lasketaan etäisyys pelaajan ja katon välillä
			etaisyysAla = (tilenKatto + self.KARTTA.tile_koko) - (self.KARTTA.koords[1] + self.koords[1]) 
			print "Etaisyydet_x: " + str(etaisyysVas) + "," + str(etaisyysOik) + "Etaisyydet_Y: " +str(etaisyysYla) + "," + str(etaisyysAla)

			#Hox hox seinien suunnat ovat käänteiset tässä koska tietenkin tilen vasen sisäseinä on oikeanpuoleinen törmättävä seinä
			if etaisyysVas > etaisyysOik:
				#Lasketaan onko ukko syvemmällä seinässä kuin ikinä mahdollista (jos on törmätään korkeus suunnassa pelkästään ja ignoorataan seinä törmäys)
				if etaisyysVas > self.maxNopeus_x +1:
					self.osuukoSeinaan_V = 1
			else:
				if etaisyysOik > self.maxNopeus_x +1:
					self.osuukoSeinaan_O = 1
			if etaisyysYla > etaisyysAla:
				if etaisyysYla > self.maxNopeus_y +1:
					self.osuukoKattoon = 1
					print "!!!!!!!!!!!!!!!!!!! OSUIT KATTOON!"
			else:
				if etaisyysAla > self.maxNopeus_y +1:
					self.osuukoLattiaan = 1
					print "!!!!!!!!!!!!!!!!!!! OSUIT LATTIAAN!"
		'''

	def AnnaTormaysFlagi(self, piste):
		#palauttaa törmätäänkö tileen annetussa pisteessä
		#Aluksi lasketaan minkä tilen sisällä ollaan kartassa
		tilenSisal_x = piste[0] / self.KARTTA.tile_koko
		tilenSisal_y = piste[1] / self.KARTTA.tile_koko
		#print "lasketaan x: %s %s = %s" % (piste[0], self.KARTTA.tile_koko, tilenSisal_x)
		#print "lasketaan y: %s %s = %s" % (piste[1], self.KARTTA.tile_koko, tilenSisal_y)
		#print "Haetaan rivia: %s ja siita tilea: %s" % (tilenSisal_x, tilenSisal_y)
		if tilenSisal_x >= 0 and tilenSisal_y >= 0:
			#print "molemmat oli positiivista: %s %s" % (tilenSisal_x, tilenSisal_y)
			tilerivi = self.KARTTA.AnnaRivi_Hit(tilenSisal_y)
			tilenro = tilerivi[tilenSisal_x]
			if tilenro != 0: #Eli tileen voi törmätä
				return 1
			else:
				return 0
		else:
			return 1
			
		
	def PaivitaKartta(self, kartta):
		self.KARTTA = kartta

class Objecti:
	def __init__(self, nimi, koords, tyyppi):
		self.nimi = nimi
		self.koords = koords
		self.tyyppi = tyyppi
		
		eriKuvat = ["portaali.png", "ilmakuplat.png"]
		
		if nimi == "Ovi":
			polku = "media/spritet/" + eriKuvat[0]
			kuva = pygame.image.load(polku)
			self.koko = [16, 32]
		if nimi == "Happi":
			polku = "media/spritet/" + eriKuvat[1]
			kuva = pygame.image.load(polku)
			self.koko = [16,32]

		self.kaikkiSpritet = TYOKALU.LataaSpritet(kuva, self.koko) #kaikki ukon mahdolliset animaatio kuvat
		self.animoitavat = [0,1,2]
		self.animMenossa = 0

	def VaihdaAnimoitava(self):
		self.animMenossa = TYOKALU.VaihdaAnimoitava(self.animoitavat, self.animMenossa)

#Periytetään ovi objecteista. Näin ollen ovi saa kaikki objecti luokan functiot mutta ei propertyjä
class Ovi(Objecti):
	def __init__(self, nimi, koords, tyyppi):
		self.nimi = nimi
		self.koords = koords
		self.tyyppi = tyyppi
		self.porttaa = None #Mihin koords ovi vie pelaajan
		self.karttaan = None #mihin map numeroon -||-
		self.koko = [16,32]

		kuva = pygame.image.load("media/spritet/portaali.png")
		self.kaikkiSpritet = TYOKALU.LataaSpritet(kuva, self.koko) #kaikki ukon mahdolliset animaatio kuvat
		self.animoitavat = [0,1,2]
		self.animMenossa = 0
		self.ParsiTyyppi(tyyppi)
		

	def LaskeObjecti(self, UKKO, KARTTA):
		if abs((UKKO.koords[0]) - (self.koords[0] - KARTTA.koords[0])) < self.koko[0]: #X akseli lasku
			if abs((UKKO.koords[1]) - (self.koords[1] - KARTTA.koords[1])) < self.koko[1]:
				if UKKO.ylosPohjas == 1:
					print "Avasit Oven! ja tyyppi:" + self.tyyppi
					print "Teleporttaa : " + str(self.porttaa[0]) + "," + str(self.porttaa[1])
					UKKO.Teleporttaa(self.porttaa)
	def ParsiTyyppi(self, tyyppi):
		tyyppi += "END"
		print "tyyppi: " + tyyppi	
		#Ovi tyypille tyeleporttaus tietojen parsinta
		teleporttaa_x  = int(TYOKALU.AnnaPala(tyyppi, 'x:', ' y:'))
		teleporttaa_y  = int(TYOKALU.AnnaPala(tyyppi, 'y:', ' m:'))
		vaihdaMap = int(TYOKALU.AnnaPala(tyyppi, 'm:', 'END'))
		print "Parsittiin %s , %s , %s" % (teleporttaa_x, teleporttaa_y, vaihdaMap)
		self.porttaa = [teleporttaa_x + 100, teleporttaa_y + 50]
		self.karttaan = vaihdaMap

class Happi(Objecti):
	def __init__(self, nimi, koords, tyyppi):
		self.nimi = nimi
		self.koords = koords
		self.tyyppi = tyyppi
		self.koko = [16,32]

		kuva = pygame.image.load("media/spritet/ilmakuplat.png")
		self.kaikkiSpritet = TYOKALU.LataaSpritet(kuva, self.koko) #kaikki ukon mahdolliset animaatio kuvat
		self.animoitavat = [0,1,2]
		self.animMenossa = 0
		

	def LaskeObjecti(self, UKKO, KARTTA):
		if abs((UKKO.koords[0]) - (self.koords[0] - KARTTA.koords[0])) < self.koko[0]: #X akseli lasku
			if abs((UKKO.koords[1]) - (self.koords[1] - KARTTA.koords[1])) < self.koko[1] + 16: #+16 koska happi objecti kuuluu olla pelaajan alapuolel
				print "SaatHappea!"
				UKKO.happi = UKKO.maxHappi
		
				

		








		







