# -*- coding:cp1251 -*-

#Kartan luokka joka hoitaa kaikki karttatoiminnot functioissa joita kutsutaan

from pygame import image as pyimg #Tileset kuvan latausta varten
import tyokalut

TYOKALU = tyokalut.Functiot()

#Huone on yhden lataus-alueen tileset ja objectit. Huone luokka sisältää myös kaikki muut huoneet listassa huoneet joita ladataan tarvittaessa (kun vaihdetaan huonetta)

class Kartta:
	def __init__(self):
		self.karttaTiedosto = None #Nämä ladataan kartta.LataaHuone functiossa koska on aikaa vievää ja näin voidaan hallita milloinka viedään suoritusaikaa ja näytetään loading screen
		self.leveys = None
		self.korkeus = None #yksikkö tilejä
		self.tile_koko = 16
		self.background = [] #Lista huoneen kaikista tausta tileistä
		self.hit = [] #Lista huoneen kaikista hit tileistä
		self.over = [] #Lista huoneen kaikista over tileistä
		self.koords = [0,0] #Kun kartta liikkuu ja pelaaja on keskellä näyttöä
		self.tile_kuvat = None
		self.ladatutObjectit = [] #tiedostosta ladatut objectit

	def LataaHuone(self, nro):
		kentat = ["ekaKarttaTesti.xml", "tokaTesti.tmx"]
		tiedosto = open("data/kartat/" + kentat[nro], "r")
		rivit = tiedosto.readlines()
		tiedosto.close()
		self.karttaTiedosto = rivit
		self.HaeKoko(rivit[1])
		dataAlkaa = self.HaeKohta("background") +2 #miltä riviltä alkaa layerin data
		self.background = self.HaeData(rivit, dataAlkaa)
		dataAlkaa = self.HaeKohta("hit") +2 #hakee hit nimiselle kerrokselle aloitus rivin
		self.hit = self.HaeData(rivit, dataAlkaa) #Haetaan kartan hit layer
		dataAlkaa = self.HaeKohta("over") +2 #+2 koska kartta data alkaa vasta seuraavalta toiselta riviltä !!!
		self.over = self.HaeData(rivit, dataAlkaa)
		self.LataaObjectit()
		

	def LataaTileset(self, nro):
		tilesetit = ["oubliette_tileset.png", "yhdTilesetitTrans.png"]
		kuva = pyimg.load("media/spritet/" + tilesetit[nro])
		tileMaara_x = kuva.get_width() / self.tile_koko
		tileMaara_y = kuva.get_height() / self.tile_koko
		print "ladattiin tileset kuva: " + tilesetit[nro] + ", jonka koko on tileina: " + str(tileMaara_x) + "x" + str(tileMaara_y)
		x1 = 0
		y1 = 0
		x2 = self.tile_koko
		y2 = self.tile_koko
		alue = (x1, y1, x2, y2)	#pygame neliön mitat (alotaX, aloitaY, kokoX, kokoY)
		tileSpritet = [] #tähän listaan tulee kaikki tilespritet
		kohta_x = 0
		kohta_y = 0
		tile = kuva.subsurface(alue) #kopioidaan alue
		tileSpritet.append(tile) #jotta 0 paikka olisi tyhjä koska se on kartta editorissa tyhjä tausta
		while kohta_y < tileMaara_y:
			while kohta_x < tileMaara_x:
				x1 = kohta_x * self.tile_koko
				y1 = kohta_y * self.tile_koko
				alue = (x1, y1, x2, y2)
				tile = kuva.subsurface(alue) #kopioidaan alue
				tileSpritet.append(tile)
				#print "kopioitiin tile: " + str(kohta_x) + "," + str(kohta_y)
				kohta_x += 1
			kohta_x = 0
			kohta_y += 1
		self.tile_kuvat = tileSpritet
		print "Tileset ladattu..."


		#print "Kopioidaan tielä alueelta: X: ", kohta_x, " Y: ", kohta_y
		tile = kuva.subsurface(alue) #kopioidaan alue

	def LataaObjectit(self):
		ekaRivi = self.HaeKohta("<objectgroup name=") #Objecti datan aloittava stringi
		vikaRivi = self.HaeKohta("</objectgroup>") #Ja lopettava
		menossa = ekaRivi
		ladatutObjectit = []
		print "Erivi: %s vRivi: %s" % (ekaRivi, vikaRivi)
		
		while menossa <= vikaRivi:
			#print "menossa: " + str(menossa)
			rivi = self.karttaTiedosto[menossa]
			if rivi.find('<object id="') != -1: #eli tällä rivillä on objecti
				nimi = TYOKALU.AnnaPala(rivi, 'name="', '" type=')
				x  = int(TYOKALU.AnnaPala(rivi, 'x="', '" y='))
				y  = int(TYOKALU.AnnaPala(rivi, 'y="', '">'))
				tyyppi = TYOKALU.AnnaPala(rivi, 'type="', '" x=')
				#if nimi == "Ovi": #Ovi tyypille tyeleporttaus tietojen parsinta
				#	teleporttaa_x  = int(TYOKALU.AnnaPala(rivi, 'type="x:', ' y:'))
				#	teleporttaa_y  = int(TYOKALU.AnnaPala(rivi, 'y:', ' m:'))
				#	vaihdaMap = int(TYOKALU.AnnaPala(rivi, 'm:', '" x="'))
				#	self.ladatutObjectit.append()
					
				print "Ladattiin olio: " + nimi + " kohdassa: " + str(x) + "," + str(y) + " tyypilla: '" + tyyppi + "'"
				POHJA = tyokalut.LadattuObjecti(nimi, [x, y], tyyppi) #luodaan objecti pohja näillä tiedoilla jotta voidaan antaa eteenpäin
				ladatutObjectit.append(POHJA)
				
			menossa += 1
		self.ladatutObjectit = ladatutObjectit

	def HaeKoko(self, asRivi):
		# asRivi = asetusrivi kartta tiedostossa
		hakusana = 'width="'
		kohta = asRivi.find(hakusana)
		data = 	asRivi[kohta +0 + len(hakusana)] #Oletetaan että tilemap koko on 3 merkkinen eli 100-999
		data += asRivi[kohta +1 + len(hakusana)]
		data += asRivi[kohta +2 + len(hakusana)]
		self.leveys = int(data)
		#print "Haettiin tilemapin leveys: " + data
		hakusana = 'height="'
		kohta = asRivi.find(hakusana)	
		data = 	asRivi[kohta +0 + len(hakusana)] #Oletetaan että tilemap koko on 3 merkkinen eli 100-999
		data += asRivi[kohta +1 + len(hakusana)]
		data += asRivi[kohta +2 + len(hakusana)]
		self.korkeus = int(data)
		#print "Haettiin tilemapin korkeus: " + data

	def HaeData(self, tiedosto, aloitus):
		#Huoneen ekan layerin data alkaa riviltä 5
		#Aloitetaan huoneen datan lukeminen siitä mistä käsketään
		kohta_x = 0
		kohta_y = aloitus
		rivi = [] #rivi on aina karttatiedoston yhden rivin tilet (vasemmalta oikealle)
		huone = [] #huone on kartan kaikki rivit (yläältä alas)
		while kohta_y <= self.korkeus + aloitus:
			rivi = tiedosto[kohta_y].split(",")
			del rivi[-1] #poistetaan /n merkki listan viimeisestä indeksistä
			rivi = map(int, rivi) #str lista -> int lista
			huone.append(rivi)
			#print "Lisattiin huoneen riviin: [" + str(kohta_y) + "] rivi: " + tiedosto[kohta_y]
			kohta_y += 1
		return huone
		print "huoneen palikoiden lataus valmis"

	def AnnaRivi_Hit(self, monesko):
		return self.hit[monesko]

	def AnnaTile(self, piste):
		x = piste[0] / self.tile_koko
		y = piste[1] / self.tile_koko
		return self.background[y][x]

	def OnkoTyhja(self, y_yla, y_ala, x_vas, x_oik):
		#Saa hitboxin reunojen koordinaatit ja palauttaa 1, jos hitboxin alueella ei ole tilejä            #VILLEN FUNCCARI
		x_vas = x_vas / self.tile_koko
		x_oik = x_oik / self.tile_koko
		y_yla = y_yla / self.tile_koko
		y_ala = y_ala / self.tile_koko
		tyhja=1
		while x_vas<=x_oik:
			while y_yla<=y_ala:
				if self.huone[y_yla][x_vas]:
					tyhja=0
				y_yla+=1
			x_vas+=1
			
		return tyhja

	def HaeKohta(self, hakusana):
		riviNro = 0
		jatka = 1
		while jatka == 1:
			onko = self.karttaTiedosto[riviNro].find(hakusana)
			if onko != -1:  #Eli löytyi
				print "kartta tiedosto alkaa riviltä %s" % (riviNro + 2)
				return riviNro #+ 2
			riviNro += 1
			
			











